/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/



/* this file contains dummy definitions for unix to be compilable */
/* the hardware access routines are faked so to say */
/* later with sicl? maybe... */

/* TODO: set error parameters for BX_E_ERROR, CZ */

#include <assert.h>
#include <memory.h>
#include <fcntl.h>

#include "xtypedef.h"
#include "xserial.h"
#include "xepp.h"
#include "xcmd.h"
#include "xhif.h"
#include "xusb.h"
#include "xpci.h"
#include "b_ioctl.h"
#include "xio.h"

#include <xutil.h>
#include <timeout.h>

extern bx_handlestype bx_handlearray[];

extern bx_int32 GlobalBaseAddr;


/* --------------------------------------------------------------------------
 * Parallel port dummy functions
 * -------------------------------------------------------------------------- */

long int BestXOpenParallel(int num)
{
  /* FirmwareInit(); */
  return 0;
}

void BestXCloseParallel(bx_portnumtype portnumber)
{
  /* FirmwareClose(); */
}

bx_errtype BestXParDeviceConnect(bx_portnumtype OsHandle)
{
  return BX_E_OK;
}

bx_errtype BestXParCheckConnection(bx_portnumtype OsHandle)
{
  return BX_E_OK;
}

void BestXParReleaseConnection(bx_portnumtype portnumber)
{
}

bx_errtype BestXParPortTimeoutSet(bx_portnumtype OsHandle, 
                                BESTTIMEOUTS * pCallersTimeouts)
{
  return BX_E_OK;
}

/* --------------------------------------------------------------------------
 * Read/write to debug buffer
 * -------------------------------------------------------------------------- */

bx_errtype BestXBasicRead(
    bx_handletype BestHandleArrIndx,
    bx_int8 * pData,       /* caller's buffer */
    bx_int32 NumBytes,     /* number of bytes to read */
    bx_int8 DataEltWidth)  /* data element width in bytes */

{
  bx_errtype    err = BX_E_OK;
  bx_handletype handle = BestHandleArrIndx;
  bx_int32 bytes_left,bytes_read;
  
  assert(pData && NumBytes < 0x0000ffff);
  
  switch (bx_handlearray[BestHandleArrIndx].port) 
  {
    case BX_PORT_OFFLINE: 
      BESTX_MEMSET( pData, 0, NumBytes );
      break;

#ifdef CUSTOM_OEM1
    case BX_PORT_OEM:
#endif
    case BX_PORT_PCI_CONF:
      bytes_left=NumBytes;
      while (bytes_left) {
        bytes_read=read(bx_handlearray[BestHandleArrIndx].portnumber,pData,bytes_left);
        bytes_left-=bytes_read;
        pData+=bytes_read;
      }
      return BX_E_OK;
      break;

    case BX_PORT_RS232:
    case BX_PORT_PCI_IO:
    case BX_PORT_PARALLEL:
    case BX_PORT_FASTHIF:
    case BX_PORT_USB:
      err = BX_E_BAD_HANDLE;
      break;
  }
  
  return BX_E_TBD;
}


bx_errtype BestXBasicWrite(
    bx_handletype BestHandleArrIndx,
    bx_int8 * pData,       /* caller's buffer */
    bx_int32 NumBytes,     /* number of bytes to write */
    bx_int8 DataEltWidth)  /* data element width in bytes */

{
  bx_errtype err;
  bx_handletype handle = BestHandleArrIndx;
  bx_int32 bytes_written,bytes_left;

  assert(pData && NumBytes < 0x0000ffff);

  switch (bx_handlearray[BestHandleArrIndx].port)
  {
    case BX_PORT_OFFLINE:
      err = BX_E_OK;
      break;

#ifdef CUSTOM_OEM1
    case BX_PORT_OEM:
#endif
    case BX_PORT_PCI_CONF:
      bytes_left=NumBytes;
      while (bytes_left) 
      {
        bytes_written=write(bx_handlearray[BestHandleArrIndx].portnumber,pData,bytes_left);
        bytes_left-=bytes_written;
        pData+=bytes_written;
      }
      return BX_E_OK;
      break;

    case BX_PORT_RS232:
    case BX_PORT_PCI_IO:
    case BX_PORT_PARALLEL:
    case BX_PORT_FASTHIF:
    case BX_PORT_USB:
      err = BX_E_BAD_HANDLE;
      break;
  }
      
  return BX_E_TBD;
}
/* --------------------------------------------------------------------------
 * PCI dummy functions
 * -------------------------------------------------------------------------- */

static bx_errtype BestXPCIDWGet(
                                bx_int32 Reg_N,              /* offset into config. space */
                                bx_portnumtype OsHandle,
                                bx_int32 * pResult);

static bx_errtype BestXPCIDWSet(
                                bx_int32 Reg_N,              /* offset into config. space */
                                bx_portnumtype OsHandle,
                                bx_int32 value);

bx_errtype BestXPCISetRegwidth(bx_portnumtype OsHandle, int regwidth)
{
  ioctl(OsHandle,IOCTL_NTIO_SET_REGWIDTH_PCI,regwidth);

  return BX_E_OK;
}

bx_errtype BestXPCIDeviceConnect(bx_portnumtype OsHandle)
{
  if (BestXPCIDWSet(PCI_CONNECT_CMD, OsHandle, PCI_CONNECT_CMD_BIT) != BX_E_OK)
  {
    /* TODO: error param */
    return BX_E_ERROR;
  }

  return BX_E_OK;
}

bx_errtype BestXPCICheckConnection(bx_portnumtype OsHandle)
{
  bx_errtype lErrCode;
  bx_int32 Result;

  if (BX_E_OK != (lErrCode = BestXPCIDWGet(PCI_CONNECT_STATUS, OsHandle, &Result)))
    return lErrCode;

  if ((Result & PCI_CONNECT_STATUS_BIT) == PCI_CONNECTION_CLOSED)
    return BX_E_NOT_CONNECTED;

  return BX_E_OK;
}

void BestXPCIReleaseConnection(bx_portnumtype portnumber)
{
  (void) BestXPCIDWSet(PCI_CONNECT_CMD, portnumber, 0x0);
  return;
}

bx_errtype BestXPciPortTimeoutSet(bx_portnumtype OsHandle, 
                                BESTTIMEOUTS * pCallersTimeouts)
{
  ioctl(OsHandle,IOCTL_NTIO_SET_TIMEOUT,pCallersTimeouts);
  return BX_E_OK;
}

bx_errtype BestXPciDevMultiFuncCheck(bx_int32 dwHPSlotId, bx_bool * fIsMultiFunc)
{
  bx_int32 Result;

  *fIsMultiFunc = 0;

  if ( BX_E_OK != BestXGenericPCIDWGet(dwHPSlotId, PCI_MF_OFFSET, &Result))
    return BX_E_NO_BEST_PCI_DEVICE_FOUND;

  *fIsMultiFunc = ((Result & PCI_MF_BIT) != 0);
  return BX_E_OK;
}

bx_errtype BestXPCIMailboxWrite(bx_int32 dwHPSlotId, bx_int32 value)
{
  bx_int32 statusdata;
  BEST_TIMER tmr;
  bx_errtype err;

  /* init timeout */
  BestStartTimeout(TIMEOUT_MAILBOX_PCI_WRITE, &tmr);

  do
  {
    /* get Mailbox status */
    if (BX_E_OK != (err = BestXGenericPCIDWGet(dwHPSlotId, PCI_MBOX_STATUS, &statusdata)))
      return err;

    if ( BestIsTimeoutDone(&tmr) ) {
      /* TODO: error param */
      return BX_E_ERROR;  /* a timeout here is an error */
    }

  } while ((statusdata & PCI_MBOX_SEND_FULL_BIT) != 0);

  /* write data to Mailbox */
  return BestXGenericPCIDWSet(dwHPSlotId, PCI_MBOX_DATA, value);
}

bx_errtype BestXPCIMailboxRead(bx_int32 dwHPSlotId, bx_int32 * pResult)
{
  bx_int32 statusdata;
  BEST_TIMER tmr;
  bx_errtype err;
  assert(pResult && "Null passed to BestXPCIMailboxRead()");

  /* init timeout */
  BestStartTimeout(TIMEOUT_MAILBOX_PCI_READ, &tmr);

  do
  {
    /* get status from Config */
    if (BX_E_OK != (err = BestXGenericPCIDWGet(dwHPSlotId, PCI_MBOX_STATUS, &statusdata)))
      return err;

    if ( BestIsTimeoutDone(&tmr) ) {
      /* TODO: error param */
      return BX_E_ERROR;               /* a timeout here is an error */
    }

  } while ((statusdata & PCI_MBOX_DATA_VALID_BIT) == 0);

  /* get data from data register */
  if (BX_E_OK != (err = BestXGenericPCIDWGet(dwHPSlotId, PCI_MBOX_DATA, &statusdata)))
    return err;

  /* get data from data register */
  *pResult = statusdata;

  /* clear the data valid bit */
  return BestXGenericPCIDWSet(dwHPSlotId, PCI_MBOX_STATUS, PCI_MBOX_DATA_VALID_BIT);
}

bx_errtype BestXOpenPCI(int portnum, bx_portnumtype * pOsHandle)
{
  bestpci_general_info geninf;
  bestpci_device_info devinf;
  int fd,devnr;
  char name[1024];
  FILE *fd1;
  char path[1024];
  char *temp=(char *)malloc(1024);      // used temporarily for the lines read from mtab
  char **ptemp=&temp;                   // pointer to pointer with read line, needed for strsep
 
  // Set default path to be used when devfs is not mounted
  strcpy(path,"/dev");
 
  // First search for the location of the devfs
  fd1=fopen("/etc/mtab","r");            // open file which contains mounted filesystems
  while (!feof(fd1)) {                   // while not eof
    fgets(temp,1024,fd1);                // read up to line end or max 1024 bytes
    if (strstr(temp," devfs ")) {        // if string " devfs " is in read line
      strsep(ptemp," ");                 // seperate string into, brake at at the spaces,
                                         // throw away the first piece (device-name)
      strcpy(path,strsep(ptemp," "));    // catch second piece (mountpount) and remember it
    }
  }
  fclose(fd1);
  free(temp);                            // Close and throw away temp-buffer
 
  sprintf(name,"%s/best/pci0",path);     // Open our generic device
 
  fd=open(name,O_RDONLY);
  if (fd<0) {
    *pOsHandle=INVALID_OS_HANDLE;
    return BX_E_ERROR;
  }
 
  ioctl(fd,0,&geninf);                   // Get the generic driver-infos
 
  // Search through all available devices till the one with right portnum is found
  devnr=0;
  
  //#ifdef CUSTOM_OEM1
  // Insure there's no stale data in the variable (init to force no match)
  devinf.slot_id.u.AsULONG = ~portnum ; 
  //#endif
  
  while ((devnr<geninf.dev_count) && (devinf.slot_id.u.AsULONG != portnum)) 
  {
    ioctl(fd,devnr,&devinf);
    devnr++;
  }
  devnr--;
  close(fd);
 
  if (devinf.slot_id.u.AsULONG == portnum) {       // If desired device is found in the system
    sprintf(name,"%s/best/pci%d",path,devnr);      // Open its device-node
    *pOsHandle=(bx_portnumtype)open(name,O_RDWR);  
    if (&pOsHandle>=0)
      return BX_E_OK;
  }

  *pOsHandle=INVALID_OS_HANDLE;

  return BX_E_ERROR;
}

bx_errtype BestXClosePCI(bx_portnumtype OsHandle)
{
  close(OsHandle);

  return BX_E_OK;
}


bx_errtype BestXGenericPCIDWSet(bx_int32 DeviceId,
    bx_int32 Reg_N,
    bx_int32 value)
{
  /* 
   DeviceID consists of BusNo(8bit),Slotnumber(5 bits) and functionnumber (3 bit):
   devid=busnumber<<8 | slotnumber<<3 | function
  */
  int fd,ret;

  if ( BestXOpenPCI(DeviceId,&fd) == BX_E_OK) 
  {
    ret=BestXPCIDWSet(Reg_N,fd,value);
    BestXClosePCI(fd);
    return ret;
  }

  return BX_E_NO_BEST_PCI_DEVICE_FOUND;
}

bx_errtype BestXGenericPCIDWGet(bx_int32 DeviceId,
    bx_int32 Reg_N,
    bx_int32 * value)
{
  /* 
   DeviceID consists of BusNo(8bit),Slotnumber(5 bits) and functionnumber (3 bit):
   devid=busnumber<<8 | slotnumber<<3 | function
  */
  int fd,ret;

  if (BestXOpenPCI(DeviceId,&fd) == BX_E_OK) 
  {
    ret=BestXPCIDWGet(Reg_N,fd,value);
    BestXClosePCI(fd);
    return ret;
  }

  return BX_E_NO_BEST_PCI_DEVICE_FOUND;
}

bx_errtype EXPORT BestXDirectRegPCIRead(
  bx_handletype handle,
  bx_int32 dir_addr,
  bx_int32 regsize,
  bx_int32 *reg_value
)
{
  int osHandle = bx_handlearray[handle].portnumber;
  b_accessporttype accessPort;

  if (osHandle == INVALID_OS_HANDLE)
  {
    return BX_E_NOT_CONNECTED;
  }

  accessPort.m_dwAddress = dir_addr;
  accessPort.m_cRegWidth = (UCHAR) (regsize & 0xFF);

  ioctl(osHandle,IOCTL_NTIO_READ_REG_DW,&accessPort);

  *reg_value = *((bx_int32 *)&accessPort);

  return BX_E_OK;
}

bx_errtype EXPORT BestXDirectRegPCIWrite(
  bx_handletype handle,
  bx_int32 dir_addr,
  bx_int32 regsize,    
  bx_int32 reg_value
)
{
  int osHandle = bx_handlearray[handle].portnumber;
  b_accessportdatatype accessPortData;

  if (osHandle == INVALID_OS_HANDLE)
    {
      return BX_E_NOT_CONNECTED;
    }

  accessPortData.m_port.m_dwAddress = dir_addr;
  accessPortData.m_port.m_cRegWidth = (UCHAR) (regsize & 0xFF);
  accessPortData.m_data = reg_value;

  ioctl(osHandle, IOCTL_NTIO_WRITE_REG_DW, &accessPortData);
  
  return BX_E_OK;  
}

static bx_errtype BestXPCIDWSet(
                              bx_int32 Reg_N,
                              bx_portnumtype OsHandle,
                              bx_int32 value)
{
  b_configdrivertype WriteBuffer;

  WriteBuffer.Offset = Reg_N;
  WriteBuffer.Data.Data = value;
  ioctl(OsHandle,IOCTL_NTIO_SET_CONFIG_DW, &WriteBuffer);
  return BX_E_OK;
}

static bx_errtype BestXPCIDWGet(
                              bx_int32 Reg_N,              /* offset into config. space */
                              bx_portnumtype OsHandle,
                              bx_int32 * pResult)
{
  bx_int32 data=Reg_N;

  ioctl(OsHandle, IOCTL_NTIO_GET_CONFIG_DW, &data);
  *pResult=data;

  return BX_E_OK;
}

bx_errtype BestXOpenIO(int intHPSlotId, bx_portnumtype * pOsHandle)
{
  return 0;
}

bx_errtype BestXCloseIO(bx_portnumtype portnumber)
{
  return BX_E_TBD_MSG;
}
/* --------------------------------------------------------------------------
 * Fast HIF dummy functions
 * -------------------------------------------------------------------------- */

bx_errtype BestXOpenHIF(bx_int32 dwCardId,
    bx_int32 * pHPSlotId,
    bx_portnumtype * pOsHandle)
{
  return BX_E_TBD_MSG;
}

bx_errtype BestXCloseHIF(bx_portnumtype OsHandle)
{
  return BX_E_TBD_MSG;
}

bx_errtype BestXHIFSetRegwidth(bx_portnumtype OsHandle, int iRegWidth)
{
  return BX_E_TBD_MSG;
}

bx_errtype BestXHIFDeviceConnect(bx_portnumtype OsHandle)
{
  return BX_E_TBD_MSG;
}

bx_errtype BestXHIFCheckConnection(bx_portnumtype OsHandle)
{
  return BX_E_TBD_MSG;
}

bx_errtype BestXHIFIsDisconnected(bx_portnumtype OsHandle)
{
  return BX_E_TBD_MSG;
}

void BestXHIFReleaseConnection(bx_portnumtype OsHandle)
{
}

bx_errtype BestXHifPortTimeoutSet(bx_portnumtype OsHandle, 
                                BESTTIMEOUTS * pCallersTimeouts)
{
  return BX_E_TBD_MSG;
}

/* --------------------------------------------------------------------------
 * USB dummy functions
 * -------------------------------------------------------------------------- */

bx_errtype BestXOpenUSB(bx_int32 dwCardId,
    bx_portnumtype * pOsHandle,
    bx_charptrtype filename)
{
  return BX_E_TBD_MSG;
}

bx_errtype BestXCloseUSB(bx_portnumtype OsHandle){return BX_E_TBD_MSG;}

bx_errtype BestXUSBDeviceConnect(bx_portnumtype OsHandle){return BX_E_TBD_MSG;}
bx_errtype BestXUSBFXDeviceConnect(bx_portnumtype OsHandle){return BX_E_TBD_MSG;}

bx_errtype BestXUSBCheckConnection(bx_portnumtype OsHandle){return BX_E_TBD_MSG;}
bx_errtype BestXUSBFXCheckConnection(bx_portnumtype OsHandle){return BX_E_TBD_MSG;}

bx_errtype BestXUSBIsDisconnected(bx_portnumtype OsHandle){return BX_E_TBD_MSG;}
bx_errtype BestXUSBFXIsDisconnected(bx_portnumtype OsHandle){return BX_E_TBD_MSG;}

void BestXUSBReleaseConnection(bx_portnumtype OsHandle){}
void BestXUSBFXReleaseConnection(bx_portnumtype OsHandle){}

bx_errtype BestXUSBPortTimeoutSet(bx_portnumtype OsHandle, 
                                BESTTIMEOUTS * pCallersTimeouts)
{
  return BX_E_TBD_MSG;
}

/*****************************************************************************
 * serial function dummies
 *****************************************************************************/

void  BestXCloseSerial (bx_portnumtype OsHandle)
{
  /* do nothing */
}
  
  
bx_errtype   BestXSerInit (bx_portnumtype OsHandle, bx_int32 baudrate )
{
  return BX_E_TBD_MSG;
}

void   BestXSerReleaseConnection (bx_portnumtype OsHandle)
{
  return;
}

bx_errtype BestXSerOnReadOrWriteError (bx_portnumtype OsHandle)
{
  return BX_E_TBD_MSG;
}

bx_errtype   BestXSerDeviceConnect (bx_portnumtype OsHandle)
{
  return BX_E_TBD_MSG;
}

bx_errtype   BestXSerPortTimeoutSet (bx_portnumtype OsHandle,
                                     BESTTIMEOUTS * pCallersTimeouts)
{
  return BX_E_TBD_MSG;
}

bx_portnumtype BestXOpenCOMInitial(int num, bx_int32 baudrate)
{
  return BX_E_TBD_MSG;
}

bx_errtype   BestXSerCheckConnection (bx_portnumtype OsHandle)
{
  return BX_E_TBD_MSG;
}
